/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.google.common.base.Predicate;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.BaseGoal;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;

public class EffectAuraGoal
extends BaseGoal {
    protected Potion effect;
    protected float auraRange = 10.0f;
    protected int effectSeconds = 5;
    protected int effectAmplifier = 0;
    protected boolean checkSight = true;
    protected float damageAmount = 0.0f;
    protected int duration = 200;
    protected int cooldownDuration = 0;
    protected int tickRate = 40;
    protected byte targetTypes;
    protected String targetCreatureType;
    public int abilityTime;
    public int cooldownTime;

    public EffectAuraGoal(BaseCreatureEntity setHost) {
        super(setHost);
        this.targetTypes = BaseCreatureEntity.TARGET_TYPES.ENEMY.id;
        this.targetCreatureType = null;
        this.abilityTime = 0;
        this.cooldownTime = this.cooldownDuration;
    }

    public EffectAuraGoal setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public EffectAuraGoal setCooldown(int cooldown) {
        this.cooldownDuration = cooldown;
        this.cooldownTime = cooldown;
        return this;
    }

    public EffectAuraGoal setTickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public EffectAuraGoal setEffect(Potion effect) {
        this.effect = effect;
        return this;
    }

    public EffectAuraGoal setEffect(String effectName) {
        this.effect = ObjectManager.getEffect(effectName);
        return this;
    }

    public EffectAuraGoal setRange(float auraRange) {
        this.auraRange = auraRange;
        return this;
    }

    public EffectAuraGoal setEffectSeconds(int baseEffectSeconds) {
        this.effectSeconds = baseEffectSeconds;
        return this;
    }

    public EffectAuraGoal setAmplifier(int effectAmplifier) {
        this.effectAmplifier = effectAmplifier;
        return this;
    }

    public EffectAuraGoal setCheckSight(boolean checkSight) {
        this.checkSight = checkSight;
        return this;
    }

    public EffectAuraGoal setDamageAmount(float damageAmount) {
        this.damageAmount = damageAmount;
        return this;
    }

    public EffectAuraGoal setTargetTypes(byte targetTypes) {
        this.targetTypes = targetTypes;
        return this;
    }

    public EffectAuraGoal setTargetCreatureType(String creatureTypeName) {
        this.targetCreatureType = creatureTypeName;
        return this;
    }

    public void func_75249_e() {
        this.cooldownTime = this.cooldownDuration;
        this.abilityTime = 0;
    }

    public void func_75246_d() {
        if (this.cooldownTime-- > 0) {
            this.abilityTime = 0;
            return;
        }
        if (this.abilityTime++ >= this.duration && this.cooldownDuration > 0) {
            this.cooldownTime = this.cooldownDuration;
            return;
        }
        if (this.abilityTime % this.tickRate != 0) {
            return;
        }
        PotionEffect effectInstance = null;
        if (this.effect != null) {
            effectInstance = new PotionEffect(this.effect, this.host.getEffectDuration(this.effectSeconds), this.effectAmplifier);
        }
        List<EntityLivingBase> aoeTargets = this.host.getNearbyEntities(EntityLivingBase.class, (Predicate<Entity>)((Predicate)entity -> {
            if (!(entity instanceof EntityLivingBase)) {
                return false;
            }
            boolean validTarget = false;
            if (entity == this.host) {
                if ((this.targetTypes & BaseCreatureEntity.TARGET_TYPES.SELF.id) > 0) {
                    validTarget = true;
                }
            } else {
                if ((this.targetTypes & BaseCreatureEntity.TARGET_TYPES.ALLY.id) > 0) {
                    if (this.host.isTamed() && this.host instanceof TameableCreatureEntity) {
                        if (entity instanceof TameableCreatureEntity && ((TameableCreatureEntity)((Object)entity)).getPlayerOwner() == ((TameableCreatureEntity)this.host).getPlayerOwner()) {
                            validTarget = true;
                        }
                    } else if (entity instanceof BaseCreatureEntity && !((BaseCreatureEntity)((Object)entity)).isTamed()) {
                        validTarget = true;
                    }
                }
                if ((this.targetTypes & BaseCreatureEntity.TARGET_TYPES.ENEMY.id) > 0 && (this.host.func_70686_a(entity.getClass()) || this.host.canAttackEntity((EntityLivingBase)entity))) {
                    validTarget = true;
                }
            }
            if (!validTarget) {
                return false;
            }
            if (this.targetCreatureType != null) {
                if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).creatureInfo.creatureType != null) {
                    return this.targetCreatureType.equals(((BaseCreatureEntity)entity).creatureInfo.creatureType.getName());
                }
                return false;
            }
            return !this.checkSight || this.host.func_70635_at().func_75522_a(entity);
        }), this.auraRange);
        for (EntityLivingBase target : aoeTargets) {
            if (effectInstance != null) {
                if (!target.func_70687_e(effectInstance)) continue;
                target.func_70690_d(effectInstance);
            }
            if (this.damageAmount == 0.0f) continue;
            EntityDamageSource damageSource = new EntityDamageSource("mob", (Entity)this.host);
            damageSource.func_151518_m();
            damageSource.func_76348_h();
            target.func_70097_a((DamageSource)damageSource, this.damageAmount);
            if (!this.host.minions.contains(target)) continue;
            this.host.onTryToDamageMinion(target, this.damageAmount);
        }
    }
}

